<?php

include "ConnectCountToServer.php";

$USERNAME = $_POST['UserName'];

// مرتب سازی جدول LeaderBoard بر اساس Record به صورت نزولی
$sql = "SELECT UserName, Record FROM LeaderBoard ORDER BY Record DESC";

$result = $conn->query($sql);

if ($result->num_rows > 0)
{
    // پیدا کردن رتبه و رکورد کاربر فعلی
    $userRank = 0; // شروع رتبه از 0
    $found = false;
    while($row = $result->fetch_assoc())
    {
        $userRank++;
        if ($row["UserName"] == $USERNAME)
        {
            $userRecord = $row["Record"];
            $found = true;
            break; // کاربر فعلی پیدا شد، از حلقه خارج می شویم
        }
    }

    // دریافت Avatar کاربر فعلی
    if ($found) {
        $sqlAvatar = "SELECT Avatar FROM Login WHERE UserName = ?";
        $stmt = $conn->prepare($sqlAvatar);
        $stmt->bind_param("s", $USERNAME);
        $stmt->execute();
        $resultAvatar = $stmt->get_result();
        if ($resultAvatar->num_rows > 0) {
            $rowAvatar = $resultAvatar->fetch_assoc();
            $userAvatar = $rowAvatar["Avatar"];
        } else {
            $userAvatar = "default_avatar"; // در صورت نبودن Avatar، مقدار پیشفرض
        }
        $stmt->close();

        // نمایش رتبه، رکورد و Avatar کاربر فعلی
        echo $USERNAME . "&" . $userRecord . "&" . $userRank . "&" . $userAvatar . ";";
    }

    // نمایش 15 رکورد برتر
    $rank = 1;
    $limit = 15; // تعداد رکوردهای برتر برای نمایش
    $result->data_seek(0); // به ابتدای نتیجه بازگشت

    while(($row = $result->fetch_assoc()) && $rank <= $limit)
    {
        $leaderUserName = $row["UserName"];
        $leaderRecord = $row["Record"];

        // دریافت Avatar کاربر برتر
        $sqlAvatar = "SELECT Avatar FROM Login WHERE UserName = ?";
        $stmt = $conn->prepare($sqlAvatar);
        $stmt->bind_param("s", $leaderUserName);
        $stmt->execute();
        $resultAvatar = $stmt->get_result();
        if ($resultAvatar->num_rows > 0) {
            $rowAvatar = $resultAvatar->fetch_assoc();
            $leaderAvatar = $rowAvatar["Avatar"];
        } else {
            $leaderAvatar = "default_avatar"; // در صورت نبودن Avatar، مقدار پیشفرض
        }
        $stmt->close();

        echo $leaderUserName . "&" . $leaderRecord . "&" . $rank . "&" . $leaderAvatar . ";";
        $rank++;
    }
}
else
{
    echo "No records found in LeaderBoard";
}

$conn->close();

?>
