<?php

include "ConnectCountToServer.php";

$USERNAME = $_POST['UserName'];
$PASSWORD = $_POST['Password'];
$DEVICEMODEL = $_POST['DeviceModel'];
$POWER = $_POST['Power'];
$Avatar = $_POST['Avatar'];

// Check if the username contains '&' symbol
if (strpos($USERNAME, '&') !== false || strpos($USERNAME, ';') !== false)
{
    // If the username contains '&' or ';' symbol, echo 'Invalid Username'
    echo "Invalid Username";
}
else
{
    // Proceed with the rest of the code
    // Check if the username already exists
    $sql = "SELECT UserName FROM Login WHERE  UserName = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $USERNAME);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0)
    {
        // Username already exists
        echo "Existed UserName";
    }
    else
    {
        // Hash the password
        $hashedPassword = password_hash($PASSWORD, PASSWORD_BCRYPT);

        // Insert the new user into the database
        $sql = "INSERT INTO Login (UserName, Password, DeviceModel, Record, Avatar) VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssss", $USERNAME, $hashedPassword, $DEVICEMODEL, $POWER, $Avatar);
        $stmt->execute();

        if ($stmt->affected_rows > 0)
        {
            echo "SignUp Successfully";
        }
        else
        {
            echo "Error inserting record: " . $stmt->error;
        }
    }
}

$conn->close();
?>
