<?php

include "ConnectCountToServer.php";

$USERNAME = $_POST['UserName'];
$PASSWORD = $_POST['Password'];
$RECORD = $_POST['Power'];
$RECORDTIME = $_POST['RecordTime'];

// Prepare the SQL statement to prevent SQL injection
$sql = $conn->prepare("SELECT Password, IsBlock FROM Login WHERE UserName = ?");
$sql->bind_param("s", $USERNAME);
$sql->execute();
$result = $sql->get_result();

if ($result->num_rows > 0)
{
    $row = $result->fetch_assoc();
    $dbPassword = $row["Password"];
    $blockStatus = $row["IsBlock"];

    if(password_verify($PASSWORD, $dbPassword)) // Compare the hashed password
    {
        if($blockStatus != 1)
        {
            // Update the record and coins in the Login table
            $updateLoginSql = $conn->prepare("UPDATE Login SET Record = ?, RecordTime = ? WHERE UserName = ?");
            $updateLoginSql->bind_param("sss", $RECORD, $RECORDTIME, $USERNAME);
            $updateLoginSql->execute();

            // Check if the user exists in the LeaderBoard table
            $checkLeaderboardSql = $conn->prepare("SELECT UserName FROM LeaderBoard WHERE UserName = ?");
            $checkLeaderboardSql->bind_param("s", $USERNAME);
            $checkLeaderboardSql->execute();
            $result = $checkLeaderboardSql->get_result();

            if ($result->num_rows > 0)
            {
                // Update the record and coins in the LeaderBoard table
                $updateLeaderboardSql = $conn->prepare("UPDATE LeaderBoard SET Record = ? WHERE UserName = ?");
                $updateLeaderboardSql->bind_param("ss", $RECORD, $USERNAME);
                $updateLeaderboardSql->execute();
            }
            else
            {
                // Insert a new record into the LeaderBoard table
                $getIdSql = $conn->prepare("SELECT ID FROM Login WHERE UserName = ?");
                $getIdSql->bind_param("s", $USERNAME);
                $getIdSql->execute();
                $getIdResult = $getIdSql->get_result();
                $row = $getIdResult->fetch_assoc();
                $ID = $row["ID"];

                $insertLeaderboardSql = $conn->prepare("INSERT INTO LeaderBoard (ID, UserName, Record) VALUES (?, ?, ?)");
                $insertLeaderboardSql->bind_param("sss", $ID, $USERNAME, $RECORD);
                $insertLeaderboardSql->execute();
            }
            echo "Data Updated Successfully";
        }
        else
        {
            echo "User is blocked!";
        }
    }
    else
    {
        // Update the IsBlock in the Login table
        $updateIsBlockSql = $conn->prepare("UPDATE Login SET IsBlock = '1' WHERE UserName = ?");
        $updateIsBlockSql->bind_param("s", $USERNAME);
        $updateIsBlockSql->execute();
        echo "Invalid password!";
    }
}
else
{
    echo "User not found!";
}

$sql->close();
$conn->close();

?>
