<?php
include "ConnectCountToServer.php"; // فایل اتصال به دیتابیس

$USERNAME = $_POST['UserName'];

if (!isset($USERNAME)) {
    echo json_encode(array("status" => "error", "message" => "UserName not provided"));
    exit();
}

// تنظیم منطقه زمانی به ساعت ایران
date_default_timezone_set('Asia/Tehran');

// آپدیت زمان HeartTimer به زمان فعلی
$updateSql = "UPDATE Login SET HeartTimer = CURRENT_TIMESTAMP WHERE UserName = ?";
$stmt = $conn->prepare($updateSql);
$stmt->bind_param("s", $USERNAME);
$stmt->execute();

if ($stmt->affected_rows > 0) {
    // دریافت زمان به روز شده
    $selectSql = "SELECT HeartTimer FROM Login WHERE UserName = ?";
    $stmt = $conn->prepare($selectSql);
    $stmt->bind_param("s", $USERNAME);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode(array("status" => "success", "HeartTimer" => $row['HeartTimer']));
    } else {
        echo json_encode(array("status" => "error", "message" => "Failed to retrieve HeartTimer"));
    }
} else {
    echo json_encode(array("status" => "error", "message" => "Failed to update HeartTimer"));
}

$stmt->close();
$conn->close();
?>
